********************************************************************************
*Project:			More Clarification, Less Item Nonresponse in Establishment Surveys? A Split-Ballot Experiment
*Author: 			Benjamin Küfner, Joseph W. Sakshaug, Stefan Zins
*Titel Do-File: 	Analysis Paper 
*Final Date: 		06.05.2021
********************************************************************************

////////////////////////////////////////////////////////////////////////////////
*1. Log-File and Dataset - CHECK
////////////////////////////////////////////////////////////////////////////////
cap log close
log using "${log_path}/Item_Non_response_analysis.log", replace

* Load data and define survey estimation
use "${data_path}/item_exper_auf.dta", clear
merge 1:1 f1 using "${data_path}/adj_weights.dta", nogenerate keep(1 3)

svyset , strata(strata) singleunit(centered)

////////////////////////////////////////////////////////////////////////////////
*2. Item Nonresponse - CHECK
////////////////////////////////////////////////////////////////////////////////
***zf7 - Earliest Hiring Date - CHECK
preserve
svy: mean INR_zf7, over (exp)
test _b[c.INR_zf7@0bn.exp] = _b[c.INR_zf7@1.exp]

gen m_INR_zf7= _b[c.INR_zf7@0bn.exp] if exp ==0
replace m_INR_zf7 = _b[c.INR_zf7@1.exp] if exp ==1
replace m_INR_zf7 = . if INR_zf7==.

generate ub_INR_zf7= _b[c.INR_zf7@0bn.exp] +   invttail(e(df_r),0.025)*_se[c.INR_zf7@0bn.exp] if exp ==0
replace ub_INR_zf7= _b[c.INR_zf7@1.exp] + invttail(e(df_r),0.025)*_se[c.INR_zf7@1.exp] if exp ==1
replace ub_INR_zf7 = . if INR_zf7==.

generate lb_INR_zf7= _b[c.INR_zf7@0bn.exp]   - invttail(e(df_r),0.025)*_se[c.INR_zf7@0bn.exp] if exp ==0
replace lb_INR_zf7= _b[c.INR_zf7@1.exp]  - invttail(e(df_r),0.025)*_se[c.INR_zf7@1.exp] if exp ==1
replace lb_INR_zf7 = . if INR_zf7==.

bys exp (INR_zf7): gen N=_n 
keep if N==1
drop if exp ==.
keep m_INR_zf7 ub_INR_zf7 lb_INR_zf7 exp
ren *_zf7 *_I1

save "${data_path}/zf7.dta", replace
restore

***zf5 - Start Search - CHECK
preserve
svy: mean INR_zf5, over (exp)
test _b[c.INR_zf5@0bn.exp] = _b[c.INR_zf5@1.exp]

gen m_INR_zf5= _b[c.INR_zf5@0bn.exp] if exp ==0
replace m_INR_zf5 = _b[c.INR_zf5@1.exp] if exp ==1
replace m_INR_zf5 = . if INR_zf5==.

generate ub_INR_zf5= _b[c.INR_zf5@0bn.exp] +   invttail(e(df_r),0.025)*_se[c.INR_zf5@0bn.exp] if exp ==0
replace ub_INR_zf5=  _b[c.INR_zf5@1.exp] + invttail(e(df_r),0.025)*_se[c.INR_zf5@1.exp] if exp ==1
replace ub_INR_zf5 = . if INR_zf5==.

generate lb_INR_zf5= _b[c.INR_zf5@0bn.exp]   - invttail(e(df_r),0.025)*_se[c.INR_zf5@0bn.exp] if exp ==0
replace lb_INR_zf5=  _b[c.INR_zf5@1.exp] - invttail(e(df_r),0.025)*_se[c.INR_zf5@1.exp] if exp ==1
replace lb_INR_zf5 = . if INR_zf5==.

bys exp (INR_zf5): gen N=_n
keep if N==1
drop if exp ==.
keep m_INR_zf5 ub_INR_zf5 lb_INR_zf5 exp
ren *_zf5 *_I2

save "${data_path}/zf5.dta", replace
restore

***zf6 - Applicant Decision -  CHECK
preserve
svy: mean INR_zf6, over (exp)
test _b[c.INR_zf6@0bn.exp] = _b[c.INR_zf6@1.exp]

gen m_INR_zf6= _b[c.INR_zf6@0bn.exp] if exp ==0
replace m_INR_zf6 = _b[c.INR_zf6@1.exp] if exp ==1
replace m_INR_zf6 = . if INR_zf6==.

generate ub_INR_zf6= _b[c.INR_zf6@0bn.exp] +   invttail(e(df_r),0.025)*_se[c.INR_zf6@0bn.exp] if exp ==0
replace ub_INR_zf6=  _b[c.INR_zf6@1.exp] + invttail(e(df_r),0.025)*_se[c.INR_zf6@1.exp] if exp ==1
replace ub_INR_zf6 = . if INR_zf6==.

generate lb_INR_zf6= _b[c.INR_zf6@0bn.exp]   - invttail(e(df_r),0.025)*_se[c.INR_zf6@0bn.exp] if exp ==0
replace lb_INR_zf6=  _b[c.INR_zf6@1.exp] - invttail(e(df_r),0.025)*_se[c.INR_zf6@1.exp] if exp ==1
replace lb_INR_zf6 = . if INR_zf6==.

bys exp (INR_zf6): gen N=_n
keep if N==1
drop if exp ==.
keep m_INR_zf6 ub_INR_zf6 lb_INR_zf6 exp
ren *_zf6 *_I3

save "${data_path}/zf6.dta", replace
restore

***one_rec - One Missing indicator - CHECK
preserve
svy: mean INR_one_rec, over (exp)
test _b[c.INR_one_rec@0bn.exp] = _b[c.INR_one_rec@1.exp]

gen m_INR_one_rec= _b[c.INR_one_rec@0bn.exp] if exp ==0
replace m_INR_one_rec = _b[c.INR_one_rec@1.exp] if exp ==1
replace m_INR_one_rec = . if INR_one_rec==.

generate ub_INR_one_rec= _b[c.INR_one_rec@0bn.exp] +   invttail(e(df_r),0.025)*_se[c.INR_one_rec@0bn.exp] if exp ==0
replace ub_INR_one_rec=  _b[c.INR_one_rec@1.exp] + invttail(e(df_r),0.025)*_se[c.INR_one_rec@1.exp] if exp ==1
replace ub_INR_one_rec = . if INR_one_rec==.

generate lb_INR_one_rec= _b[c.INR_one_rec@0bn.exp]   - invttail(e(df_r),0.025)*_se[c.INR_one_rec@0bn.exp] if exp ==0
replace lb_INR_one_rec=  _b[c.INR_one_rec@1.exp] - invttail(e(df_r),0.025)*_se[c.INR_one_rec@1.exp] if exp ==1
replace lb_INR_one_rec = . if INR_one_rec==.

bys exp (INR_one_rec): gen N=_n
keep if N==1
drop if exp ==.
keep m_INR_one_rec ub_INR_one_rec lb_INR_one_rec exp
ren *_one_rec *_I4

save "${data_path}/one_rec.dta", replace
restore

***all_rec - All Missing indicator - CHECK
preserve
svy: mean INR_all_rec, over (exp)
test _b[c.INR_all_rec@0bn.exp] = _b[c.INR_all_rec@1.exp]

gen m_INR_all_rec= _b[c.INR_all_rec@0bn.exp] if exp ==0
replace m_INR_all_rec =  _b[c.INR_all_rec@1.exp] if exp ==1
replace m_INR_all_rec = . if INR_all_rec==.

generate ub_INR_all_rec= _b[c.INR_all_rec@0bn.exp] +   invttail(e(df_r),0.025)*_se[c.INR_all_rec@0bn.exp] if exp ==0
replace ub_INR_all_rec=  _b[c.INR_all_rec@1.exp] + invttail(e(df_r),0.025)*_se[c.INR_all_rec@1.exp] if exp ==1
replace ub_INR_all_rec = . if INR_all_rec==.

generate lb_INR_all_rec= _b[c.INR_all_rec@0bn.exp]   - invttail(e(df_r),0.025)*_se[c.INR_all_rec@0bn.exp] if exp ==0
replace lb_INR_all_rec=  _b[c.INR_all_rec@1.exp] - invttail(e(df_r),0.025)*_se[c.INR_all_rec@1.exp] if exp ==1
replace lb_INR_all_rec = . if INR_all_rec==.

bys exp (INR_all_rec): gen N=_n
keep if N==1
drop if exp ==.
keep m_INR_all_rec ub_INR_all_rec lb_INR_all_rec exp
ren *_all_rec *_I5

save "${data_path}/all_rec.dta", replace
restore


***Graph
preserve
use "${data_path}/zf7.dta" , clear
merge 1:1 exp using  "${data_path}/zf5.dta" , nogenerate
merge 1:1 exp using  "${data_path}/zf6.dta" , nogenerate
merge 1:1 exp using  "${data_path}/one_rec.dta" , nogenerate
merge 1:1 exp using  "${data_path}/all_rec.dta" , nogenerate

reshape long m_INR_I lb_INR_I ub_INR_I ,i(exp) j(item)

la def item 1 "Earliest Hiring Date" 2"Start Search Date" 3 "Applicant Decision Date" 4 "1+ Missing Date" 5 "All Missing Dates"
la val item item

graph twoway  (bar m_INR_I exp if exp==1, subtitle(,fcolor(white) lcolor(white)) by(item, cols(1)  legend(off) graphregion(color(white))  ///
plotregion(color(white) margin(t=3.5 b=3.5 ))  note("") title("") imargin (vsmall)) barw(0.8) color(teal) horizontal) ///
(bar m_INR_I exp if exp==0, by(item) barw(0.8) color(teal) horizontal) (rcap ub_INR_I lb_INR_I exp, by(item) lcolor(black) horizontal), ///
ylabel(0 "Control" 1 "Treatment", angle(-35) nogrid)  legend(off) ytitle("") xtitle("Item Nonresponse (%)", lcolor(black) ) title("") ///
graphregion(color(white))  legend(off) ysc(off) xsc(r(0 0.30) titlegap (2000)) xlabel(0 "0" 0.05 "5" 0.1 "10" 0.15 "15" 0.2 "20" 0.25 "25" 0.3 "30", angle(0) nogrid) ///
plotregion(color(white) margin(t=2.0 b=2.0 )) 
graph export "${vector_path}\Item_Nonresponse_fig_4.svg", replace
graph export "${doku_path}\Item nonresponse\Item_Nonresponse_comb.png", replace
restore


////////////////////////////////////////////////////////////////////////////////
*3. Item Duration - CHECK
////////////////////////////////////////////////////////////////////////////////

foreach var in 5 6 7 {
	
	*Generation of Censored variable - CHECK
	gen duration_zf`var'_cens = duration_zf`var'
	replace duration_zf`var'_cens =. if duration_zf`var'_cens >900 		// Excluding observations with more than 900 seconds.

	*Settings for the figures - CHECK
	if `var' == 7 {
		local title = "Earliest Hiring Date"
		local legend = "on"
	}
	else if `var' == 6 {
	local title = "Applicant Decision Date"
	local legend = "off"
	}
	else {
	local title = "Search Start Date"
	local legend = "off"
	}
	
	
	*All participants - CHECK
	preserve
	svy: mean duration_zf`var'_cens, over (exp)
	test _b[c.duration_zf`var'_cens@0bn.exp] = _b[c.duration_zf`var'_cens@1.exp]

	gen mean_dur_`var'_all= _b[c.duration_zf`var'_cens@0bn.exp] if exp ==0
	replace mean_dur_`var'_all = _b[c.duration_zf`var'_cens@1.exp] if exp ==1
	replace mean_dur_`var'_all = . if duration_zf`var'_cens==.

	generate ub_dur_`var'_all= _b[c.duration_zf`var'_cens@0bn.exp] +   invttail(e(df_r),0.025)*_se[c.duration_zf`var'_cens@0bn.exp] if exp ==0
	replace ub_dur_`var'_all=  _b[c.duration_zf`var'_cens@1.exp] + invttail(e(df_r),0.025)*_se[c.duration_zf`var'_cens@1.exp] if exp ==1
	replace ub_dur_`var'_all = . if duration_zf`var'_cens==.

	generate lb_dur_`var'_all= _b[c.duration_zf`var'_cens@0bn.exp]   - invttail(e(df_r),0.025)*_se[c.duration_zf`var'_cens@0bn.exp] if exp ==0
	replace lb_dur_`var'_all=  _b[c.duration_zf`var'_cens@1.exp] - invttail(e(df_r),0.025)*_se[c.duration_zf`var'_cens@1.exp] if exp ==1
	replace lb_dur_`var'_all = . if duration_zf`var'_cens==.

	bys exp (INR_zf`var'): gen N=_n
	keep if N==1
	drop if exp ==.
	keep mean_dur_`var'_all ub_dur_`var'_all lb_dur_`var'_all exp
	
	save "${data_path}/dur_all_zf`var'.dta", replace
	restore
	
	*Respondents - CHECK
	preserve
	svy: mean duration_zf`var'_cens if INR_zf`var' ==0, over (exp)
	test _b[c.duration_zf`var'_cens@0bn.exp] = _b[c.duration_zf`var'_cens@1.exp]
	
	
	gen mean_dur_`var'_resp= _b[c.duration_zf`var'_cens@0bn.exp] if exp ==0
	replace mean_dur_`var'_resp =  _b[c.duration_zf`var'_cens@1.exp] if exp ==1
	replace mean_dur_`var'_resp = . if duration_zf`var'_cens==.

	generate ub_dur_`var'_resp= _b[c.duration_zf`var'_cens@0bn.exp] +   invttail(e(df_r),0.025)*_se[c.duration_zf`var'_cens@0bn.exp] if exp ==0
	replace ub_dur_`var'_resp=  _b[c.duration_zf`var'_cens@1.exp] + invttail(e(df_r),0.025)*_se[c.duration_zf`var'_cens@1.exp] if exp ==1
	replace ub_dur_`var'_resp = . if duration_zf`var'_cens==.

	generate lb_dur_`var'_resp= _b[c.duration_zf`var'_cens@0bn.exp]   - invttail(e(df_r),0.025)*_se[c.duration_zf`var'_cens@0bn.exp] if exp ==0
	replace lb_dur_`var'_resp=  _b[c.duration_zf`var'_cens@1.exp] - invttail(e(df_r),0.025)*_se[c.duration_zf`var'_cens@1.exp] if exp ==1
	replace lb_dur_`var'_resp = . if duration_zf`var'_cens==.

	bys exp (INR_zf`var'): gen N=_n
	keep if N==1
	drop if exp ==.
	keep mean_dur_`var'_resp ub_dur_`var'_resp lb_dur_`var'_resp exp
	
	save "${data_path}/dur_resp_zf`var'.dta", replace
	restore
	
	*Nonrespondents - CHECK
	preserve
	svy: mean duration_zf`var'_cens if INR_zf`var' ==1, over (exp)
	test _b[c.duration_zf`var'_cens@0bn.exp] = _b[c.duration_zf`var'_cens@1.exp]

	gen mean_dur_`var'_nonresp= _b[c.duration_zf`var'_cens@0bn.exp] if exp ==0
	replace mean_dur_`var'_nonresp =  _b[c.duration_zf`var'_cens@1.exp] if exp ==1
	replace mean_dur_`var'_nonresp = . if duration_zf`var'_cens==.

	generate ub_dur_`var'_nonresp= _b[c.duration_zf`var'_cens@0bn.exp] +   invttail(e(df_r),0.025)*_se[c.duration_zf`var'_cens@0bn.exp] if exp ==0
	replace ub_dur_`var'_nonresp=  _b[c.duration_zf`var'_cens@1.exp] + invttail(e(df_r),0.025)*_se[c.duration_zf`var'_cens@1.exp] if exp ==1
	replace ub_dur_`var'_nonresp = . if duration_zf`var'_cens==.

	generate lb_dur_`var'_nonresp= _b[c.duration_zf`var'_cens@0bn.exp]   - invttail(e(df_r),0.025)*_se[c.duration_zf`var'_cens@0bn.exp] if exp ==0
	replace lb_dur_`var'_nonresp=  _b[c.duration_zf`var'_cens@1.exp] - invttail(e(df_r),0.025)*_se[c.duration_zf`var'_cens@1.exp] if exp ==1
	replace lb_dur_`var'_nonresp = . if duration_zf`var'_cens==.
	
	bys exp (INR_zf`var'): gen N=_n
	keep if N==1
	drop if exp ==.
	keep mean_dur_`var'_nonresp ub_dur_`var'_nonresp lb_dur_`var'_nonresp exp
		
	save "${data_path}/dur_nonresp_zf`var'.dta", replace
	restore	
}


***Graph 
preserve
clear
insobs 2
gen N=_n
gen exp =0 if N==1
replace exp =1 if N==2
drop N

foreach var in all resp nonresp {
	forval item =5/7 {
		merge 1:1 exp using  "${data_path}/dur_`var'_zf`item'.dta" , nogenerate
	}
}

ren *_all *_1
ren *_resp *_2
ren *_nonresp *_3

reshape long mean_dur_5_ mean_dur_6_ mean_dur_7_ lb_dur_5_ lb_dur_6_ lb_dur_7_  ub_dur_5_ ub_dur_6_ ub_dur_7_  ,i(exp) j(group)
la def group 1 "All Eligible Participants" 2"Respondents" 3 "Nonrespondents" 
la val group group

ren *_5_ *5
ren *_6_ *6
ren *_7_ *7
reshape long mean_dur lb_dur ub_dur ,i(exp group) j(item)
recode item (5=2) (6=3) (7=1)
la def item_2 1 "Earliest Hiring Date" 2"Start Search Date" 3 "Applicant Decision Date" 
la val item item_2

*Graph
graph twoway  (bar mean_dur exp if exp==1, subtitle(,fcolor(white) lcolor(white)) by(item group, cols(3) iscale(*0.8) imargin(medium) colf legend(off) graphregion(color(white))   ///
plotregion(color(white))  note("") title("") ) barw(0.5) color(teal) horizontal) (bar mean_dur exp if exp==0, by(item group) barw(0.5) color(teal) horizontal) (rcap ub_dur lb_dur exp, by(item group) lcolor(black) horizontal),  ///
ylabel(0 "Control" 1 "Treatment", angle(-45) nogrid labsize(medium)) legend(off) ytitle("") xtitle("Item Duration (seconds)", lcolor(black)) title("") xlabel(0 10 20 30 40 50 60 70 , angle(0) nogrid) ///
graphregion(color(white))  legend(off)  ///
plotregion(color(white) margin(t=3.5 b=3.5 )) 
gr_edit .graphs[1].subtitle.text[1]=`"Earliest Hiring Date"'
gr_edit .graphs[2].subtitle.text[1]=`"Earliest Hiring Date"'
gr_edit .graphs[3].subtitle.text[1]=`"Earliest Hiring Date"'
gr_edit .graphs[4].subtitle.text[1]=`"Start Search Date"'
gr_edit .graphs[5].subtitle.text[1]=`"Start Search Date"'
gr_edit .graphs[6].subtitle.text[1]=`"Start Search Date"'
gr_edit .graphs[7].subtitle.text[1]=`"Applicant Decision Date"'
gr_edit .graphs[8].subtitle.text[1]=`"Applicant Decision Date"'
gr_edit .graphs[9].subtitle.text[1]=`"Applicant Decision Date"'

gr_edit .AddTextBox added_text editor 94 65
gr_edit .added_text[1].text = {}
gr_edit .added_text[1].text.Arrpush All Eligible Respondents
gr_edit .added_text[1].style.editstyle  angle(default) size( sztype(relative) val(3.4) allow_pct(1)) color(black) horizontal(left) vertical(middle) margin( gleft( sztype(relative) val(0) allow_pct(1)) gright( sztype(relative) val(0) allow_pct(1)) gtop( sztype(relative) val(0) allow_pct(1)) gbottom( sztype(relative) val(0) allow_pct(1))) linegap( sztype(relative) val(0) allow_pct(1)) drawbox(no) boxmargin( gleft( sztype(relative) val(0) allow_pct(1)) gright( sztype(relative) val(0) allow_pct(1)) gtop( sztype(relative) val(0) allow_pct(1)) gbottom( sztype(relative) val(0) allow_pct(1))) fillcolor(bluishgray) linestyle( width( sztype(relative) val(.2) allow_pct(1)) color(black) pattern(solid) align(inside)) box_alignment(center) editcopy

gr_edit .AddTextBox added_text editor 65 65
gr_edit .added_text[2].text = {}
gr_edit .added_text[2].text.Arrpush Item Respondents
gr_edit .added_text[2].style.editstyle  angle(default) size( sztype(relative) val(3.4) allow_pct(1)) color(black) horizontal(left) vertical(middle) margin( gleft( sztype(relative) val(0) allow_pct(1)) gright( sztype(relative) val(0) allow_pct(1)) gtop( sztype(relative) val(0) allow_pct(1)) gbottom( sztype(relative) val(0) allow_pct(1))) linegap( sztype(relative) val(0) allow_pct(1)) drawbox(no) boxmargin( gleft( sztype(relative) val(0) allow_pct(1)) gright( sztype(relative) val(0) allow_pct(1)) gtop( sztype(relative) val(0) allow_pct(1)) gbottom( sztype(relative) val(0) allow_pct(1))) fillcolor(bluishgray) linestyle( width( sztype(relative) val(.2) allow_pct(1)) color(black) pattern(solid) align(inside)) box_alignment(center) editcopy

gr_edit .AddTextBox added_text editor 36 65
gr_edit .added_text[3].text = {}
gr_edit .added_text[3].text.Arrpush Item Nonrespondents
gr_edit .added_text[3].style.editstyle  angle(default) size( sztype(relative) val(3.4) allow_pct(1)) color(black) horizontal(left) vertical(middle) margin( gleft( sztype(relative) val(0) allow_pct(1)) gright( sztype(relative) val(0) allow_pct(1)) gtop( sztype(relative) val(0) allow_pct(1)) gbottom( sztype(relative) val(0) allow_pct(1))) linegap( sztype(relative) val(0) allow_pct(1)) drawbox(no) boxmargin( gleft( sztype(relative) val(0) allow_pct(1)) gright( sztype(relative) val(0) allow_pct(1)) gtop( sztype(relative) val(0) allow_pct(1)) gbottom( sztype(relative) val(0) allow_pct(1))) fillcolor(bluishgray) linestyle( width( sztype(relative) val(.2) allow_pct(1)) color(black) pattern(solid) align(inside)) box_alignment(center) editcopy

graph export "${vector_path}\Item_Duration_fig_3.svg", replace
graph export "${doku_path}\Duration\Duration_comb.png", replace
restore

graph drop _all



////////////////////////////////////////////////////////////////////////////////
*4. Data Quality - CHECK
////////////////////////////////////////////////////////////////////////////////
***zf5 - Start Search - CHECK
preserve
svy: mean poor_quality_zf5, over (exp)
test _b[c.poor_quality_zf5@0bn.exp] = _b[c.poor_quality_zf5@1.exp]

gen m_poor_quality_zf5= _b[c.poor_quality_zf5@0bn.exp] if exp ==0
replace m_poor_quality_zf5 = _b[c.poor_quality_zf5@1.exp] if exp ==1
replace m_poor_quality_zf5 = . if poor_quality_zf5==.

generate ub_poor_quality_zf5= _b[c.poor_quality_zf5@0bn.exp] +   invttail(e(df_r),0.025)*_se[c.poor_quality_zf5@0bn.exp] if exp ==0
replace ub_poor_quality_zf5=  _b[c.poor_quality_zf5@1.exp] + invttail(e(df_r),0.025)*_se[c.poor_quality_zf5@1.exp] if exp ==1
replace ub_poor_quality_zf5 = . if poor_quality_zf5==.

generate lb_poor_quality_zf5= _b[c.poor_quality_zf5@0bn.exp]   - invttail(e(df_r),0.025)*_se[c.poor_quality_zf5@0bn.exp] if exp ==0
replace lb_poor_quality_zf5=  _b[c.poor_quality_zf5@1.exp] - invttail(e(df_r),0.025)*_se[c.poor_quality_zf5@1.exp] if exp ==1
replace lb_poor_quality_zf5 = . if poor_quality_zf5==.

bys exp (INR_zf5): gen N=_n 
keep if N==1
drop if exp ==.
keep m_poor_quality_zf5 ub_poor_quality_zf5 lb_poor_quality_zf5 exp
ren *_zf5 *_I1

save "${data_path}/data_zf5.dta", replace
restore

***zf6 - Applicant Decision - CHECK
preserve
svy: mean poor_quality_zf6, over (exp)
test _b[c.poor_quality_zf6@0bn.exp] = _b[c.poor_quality_zf6@1.exp]

gen m_poor_quality_zf6= _b[c.poor_quality_zf6@0bn.exp] if exp ==0
replace m_poor_quality_zf6 =  _b[c.poor_quality_zf6@1.exp] if exp ==1
replace m_poor_quality_zf6 = . if poor_quality_zf6==.

generate ub_poor_quality_zf6= _b[c.poor_quality_zf6@0bn.exp] +   invttail(e(df_r),0.025)*_se[c.poor_quality_zf6@0bn.exp] if exp ==0
replace ub_poor_quality_zf6=  _b[c.poor_quality_zf6@1.exp] + invttail(e(df_r),0.025)*_se[c.poor_quality_zf6@1.exp] if exp ==1
replace ub_poor_quality_zf6 = . if poor_quality_zf6==.

generate lb_poor_quality_zf6= _b[c.poor_quality_zf6@0bn.exp]   - invttail(e(df_r),0.025)*_se[c.poor_quality_zf6@0bn.exp] if exp ==0
replace lb_poor_quality_zf6=  _b[c.poor_quality_zf6@1.exp] - invttail(e(df_r),0.025)*_se[c.poor_quality_zf6@1.exp] if exp ==1
replace lb_poor_quality_zf6 = . if poor_quality_zf6==.


bys exp (INR_zf6): gen N=_n 
keep if N==1
drop if exp ==.
keep m_poor_quality_zf6 ub_poor_quality_zf6 lb_poor_quality_zf6 exp
ren *_zf6 *_I2

save "${data_path}/data_zf6.dta", replace
restore



***one_rec - At least one implausible Value - CHECK
preserve
svy: mean poor_quality_one, over (exp)
test _b[c.poor_quality_one@0bn.exp] = _b[c.poor_quality_one@1.exp]

gen m_poor_quality_one= _b[c.poor_quality_one@0bn.exp] if exp ==0
replace m_poor_quality_one =  _b[c.poor_quality_one@1.exp] if exp ==1
replace m_poor_quality_one = . if poor_quality_one==.

generate ub_poor_quality_one= _b[c.poor_quality_one@0bn.exp] +   invttail(e(df_r),0.025)*_se[c.poor_quality_one@0bn.exp] if exp ==0
replace ub_poor_quality_one=  _b[c.poor_quality_one@1.exp] + invttail(e(df_r),0.025)*_se[c.poor_quality_one@1.exp] if exp ==1
replace ub_poor_quality_one = . if poor_quality_one==.

generate lb_poor_quality_one= _b[c.poor_quality_one@0bn.exp]   - invttail(e(df_r),0.025)*_se[c.poor_quality_one@0bn.exp] if exp ==0
replace lb_poor_quality_one=  _b[c.poor_quality_one@1.exp] - invttail(e(df_r),0.025)*_se[c.poor_quality_one@1.exp] if exp ==1
replace lb_poor_quality_one = . if poor_quality_one==.

bys exp (INR_one_rec): gen N=_n 
keep if N==1
drop if exp ==.
keep m_poor_quality_one ub_poor_quality_one lb_poor_quality_one exp
ren *_one *_I3

save "${data_path}/data_one.dta", replace
restore

***all_rec - All implausible Values -  CHECK
preserve
svy: mean poor_quality_all, over (exp)
test _b[c.poor_quality_all@0bn.exp] = _b[c.poor_quality_all@1.exp]

gen m_poor_quality_all= _b[c.poor_quality_all@0bn.exp] if exp ==0
replace m_poor_quality_all = _b[c.poor_quality_all@1.exp] if exp ==1
replace m_poor_quality_all = . if poor_quality_all==.

generate ub_poor_quality_all= _b[c.poor_quality_all@0bn.exp] +   invttail(e(df_r),0.025)*_se[c.poor_quality_all@0bn.exp] if exp ==0
replace ub_poor_quality_all=  _b[c.poor_quality_all@1.exp] + invttail(e(df_r),0.025)*_se[c.poor_quality_all@1.exp] if exp ==1
replace ub_poor_quality_all = . if poor_quality_all==.

generate lb_poor_quality_all= _b[c.poor_quality_all@0bn.exp]   - invttail(e(df_r),0.025)*_se[c.poor_quality_all@0bn.exp] if exp ==0
replace lb_poor_quality_all= _b[c.poor_quality_all@1.exp] - invttail(e(df_r),0.025)*_se[c.poor_quality_all@1.exp] if exp ==1
replace lb_poor_quality_all = . if poor_quality_all==.

bys exp (INR_all_rec): gen N=_n 
keep if N==1
drop if exp ==.
keep m_poor_quality_all ub_poor_quality_all lb_poor_quality_all exp
ren *_all *_I4

save "${data_path}/data_all.dta", replace
restore

***Graph
preserve
use "${data_path}/data_zf5.dta" , clear
merge 1:1 exp using  "${data_path}/data_zf6.dta" , nogenerate
merge 1:1 exp using  "${data_path}/data_one.dta" , nogenerate
merge 1:1 exp using  "${data_path}/data_all.dta" , nogenerate

reshape long m_poor_quality_I lb_poor_quality_I ub_poor_quality_I ,i(exp) j(item)

la def item 1 "Start Search Date" 2"Applicant Decision Date" 3 "1+ Implausible Date" 4 "All Implausible Dates"
la val item item

graph twoway  (bar m_poor_quality_I exp if exp==1, subtitle(,fcolor(white) lcolor(white)) by(item, cols(1)  legend(off) graphregion(color(white))  ///
plotregion(color(white) margin(t=3.5 b=3.5 ))  note("") title("") imargin (vsmall)) barw(0.8) color(teal) horizontal) ///
(bar m_poor_quality_I exp if exp==0, by(item) barw(0.8) color(teal) horizontal) (rcap ub_poor_quality_I lb_poor_quality_I exp, by(item) lcolor(black) horizontal), ///
ylabel(0 "Control" 1 "Treatment", angle(-35) nogrid)  legend(off) ytitle("") xtitle("Share of Implausible Values (%)", lcolor(black) ) title("") ///
graphregion(color(white))  legend(off) ysc(off) xsc(r(0 0.10) titlegap (2000)) xlabel(0 "0" 0.025 "2.5" 0.05 "5" 0.075 "7.5" 0.1 "10", angle(0) nogrid) ///
plotregion(color(white) margin(t=2.0 b=2.0 )) 
graph export "${vector_path}\Data_Quality_fig_5.svg", replace
graph export "${doku_path}\Data Quality\Data_Qualiy_comb.png", replace
restore




////////////////////////////////////////////////////////////////////////////////
*5. Spill Over - CHECK
////////////////////////////////////////////////////////////////////////////////

***Item-Non-Response - CHECK
preserve
svy: mean INR_zf4, over (exp)
test _b[c.INR_zf4@0bn.exp] = _b[c.INR_zf4@1.exp]


gen m_INR_zf4= _b[c.INR_zf4@0bn.exp] if exp ==0
replace m_INR_zf4 =  _b[c.INR_zf4@1.exp] if exp ==1
replace m_INR_zf4 = . if INR_zf4==.

generate ub= _b[c.INR_zf4@0bn.exp] +   invttail(e(df_r),0.025)*_se[c.INR_zf4@0bn.exp] if exp ==0
replace ub=  _b[c.INR_zf4@1.exp] + invttail(e(df_r),0.025)*_se[c.INR_zf4@1.exp] if exp ==1
replace ub = . if INR_zf4==.

generate lb= _b[c.INR_zf4@0bn.exp]   - invttail(e(df_r),0.025)*_se[c.INR_zf4@0bn.exp] if exp ==0
replace lb= _b[c.INR_zf4@1.exp] - invttail(e(df_r),0.025)*_se[c.INR_zf4@1.exp] if exp ==1
replace lb = . if INR_zf4==.

graph twoway  (bar m_INR_zf4 exp if exp==1, barw(0.8) color(teal) horizontal) (bar m_INR_zf4 exp if exp==0, barw(0.8) color(teal) horizontal) (rcap ub lb exp, lcolor(black) horizontal), ylabel(0 "Control" 1 "Treatment", angle(-35) nogrid)  legend(off) ytitle("") xtitle("Item Nonresponse (%)") xsc(r(0 0.25)) xlabel(0 "0" 0.05 "5" 0.1 "10" 0.15 "15" 0.2 "20" 0.25 "25" 0.3 "30", angle(0) nogrid)  title("") ///
graphregion(color(white)) legend(size(vsmall) symxsize(7)) ///
plotregion(color(white) margin(t=1.5 b=1.5 )) 
graph save INR, replace
graph export "${doku_path}\Spill Over\Item-Non-Response.png", replace
restore

***Item Duration - CHECK
preserve
gen duration_zf4_cens = duration_zf4
replace duration_zf4_cens =. if duration_zf4_cens >900 		// Excluding observations with more than 900 seconds.

svy: mean duration_zf4_cens, over (exp)
test _b[c.duration_zf4_cens@0bn.exp] = _b[c.duration_zf4_cens@1.exp]


gen mean= _b[c.duration_zf4_cens@0bn.exp] if exp ==0
replace mean =  _b[c.duration_zf4_cens@1.exp] if exp ==1
replace mean = . if duration_zf4_cens==.

generate ub= _b[c.duration_zf4_cens@0bn.exp] +   invttail(e(df_r),0.025)*_se[c.duration_zf4_cens@0bn.exp] if exp ==0
replace ub=  _b[c.duration_zf4_cens@1.exp] + invttail(e(df_r),0.025)*_se[c.duration_zf4_cens@1.exp] if exp ==1
replace ub = . if duration_zf4_cens==.

generate lb= _b[c.duration_zf4_cens@0bn.exp]   - invttail(e(df_r),0.025)*_se[c.duration_zf4_cens@0bn.exp] if exp ==0
replace lb=  _b[c.duration_zf4_cens@1.exp] - invttail(e(df_r),0.025)*_se[c.duration_zf4_cens@1.exp] if exp ==1
replace lb = . if duration_zf4_cens==.

graph twoway  (bar mean exp if exp==1, barw(0.8) color(teal) horizontal) (bar mean exp if exp==0, barw(0.8) color(teal) horizontal) (rcap ub lb exp, lcolor(black) horizontal), ylabel(0 "Control" 1 "Treatment", angle(-35) nogrid)  legend(off) ytitle("") xtitle("Item Duration (seconds)")  xsc(r(0 70))  title("") xlabel(0 10 20 30 40 50 60 70  , angle(0) nogrid) ///
graphregion(color(white)) legend(size(vsmall) symxsize(7))  ///
plotregion(color(white) margin(t=1.5 b=1.5 )) 
graph save dur, replace
graph export "${doku_path}\Spill Over\Duration.png", replace
restore

***Data Quality - CHECK
preserve
svy: mean poor_quality_zf4, over (exp)
test _b[c.poor_quality_zf4@0bn.exp] = _b[c.poor_quality_zf4@1.exp]

gen m_poor_quality_zf4= _b[c.poor_quality_zf4@0bn.exp] if exp ==0
replace m_poor_quality_zf4 =  _b[c.poor_quality_zf4@1.exp] if exp ==1
replace m_poor_quality_zf4 = . if poor_quality_zf4==.

generate ub= _b[c.poor_quality_zf4@0bn.exp] +   invttail(e(df_r),0.025)*_se[c.poor_quality_zf4@0bn.exp] if exp ==0
replace ub=  _b[c.poor_quality_zf4@1.exp] + invttail(e(df_r),0.025)*_se[c.poor_quality_zf4@1.exp] if exp ==1
replace ub = . if poor_quality_zf4==.

generate lb= _b[c.poor_quality_zf4@0bn.exp]   - invttail(e(df_r),0.025)*_se[c.poor_quality_zf4@0bn.exp] if exp ==0
replace lb=  _b[c.poor_quality_zf4@1.exp] - invttail(e(df_r),0.025)*_se[c.poor_quality_zf4@1.exp] if exp ==1
replace lb = . if poor_quality_zf4==.

graph twoway  (bar m_poor_quality_zf4 exp if exp==1, barw(0.8) color(teal) horizontal) (bar m_poor_quality_zf4 exp if exp==0, barw(0.8) color(teal) horizontal) (rcap ub lb exp, lcolor(black) horizontal), ylabel(0 "Control" 1 "Treatment", angle(-35) nogrid) legend(off) ytitle("") xtitle("Share of Implausible Values (%)") xsc(r(0 0.1)) xlabel(0 "0" 0.025 "2.5" 0.05 "5" 0.075 "7.5"  0.1 "10", angle(0) nogrid)  title("") ///
graphregion(color(white))  legend(size(vsmall) symxsize(7)) ///
plotregion(color(white) margin(t=1.5 b=1.5 )) 
graph save quality, replace
graph export "${doku_path}\Spill Over\Data Quality.png", replace
restore


graph combine  dur.gph INR.gph quality.gph, title(Spillover, color(black)) col(1) imargin(zero) iscale(0.7) graphregion(color(white))  ///
plotregion(color(white) margin(t=1.5 b=1.5 ))
graph export "${vector_path}\Spill_over_fig_6.svg", replace
graph export "${doku_path}\Spill Over\Combined.png", replace
graph drop _all

////////////////////////////////////////////////////////////////////////////////
*6. Effects in Subgroups - CHECK
////////////////////////////////////////////////////////////////////////////////
*Establishmenet Size
foreach var in zf7 zf5 zf6 zf4 {
svy: reg INR_`var' exp##gkb5_2
}

foreach var in zf7 zf5 zf6 zf4 {
	forval n =1/5{
		di `n'
		svy: mean INR_`var' , over(exp), if gkb5_2 ==`n'
		test _b[c.INR_`var'@0bn.exp] = _b[c.INR_`var'@1.exp]
}
}

*Region
foreach var in zf7 zf5 zf6 zf4 {
svy: reg INR_`var' exp##gebiet04
}

foreach var in zf7 zf5 zf6 zf4 {
	forval n =1/2{
			di `n'
			svy: mean INR_`var' , over(exp), if gebiet04 ==`n'
			test _b[c.INR_`var'@0bn.exp] = _b[c.INR_`var'@1.exp]
}
}

*Industry
foreach var in zf7 zf5 zf6 zf4 {
svy: reg INR_`var' exp##industry
}

foreach var in zf7 zf5 zf6 zf4 {
	forval n =1/5{
		di `n'
		svy: mean INR_`var' , over(exp), if industry ==`n'
		test _b[c.INR_`var'@0bn.exp] = _b[c.INR_`var'@1.exp]
}
}

*Collective Agreement
foreach var in zf7 zf5 zf6 zf4  {
svy: reg INR_`var' exp##coll_agree
}

foreach var in zf7 zf5 zf6 zf4 {
	forval n =0/2{
		di `n'
		svy: mean INR_`var' , over(exp), if coll_agree ==`n'
		test _b[c.INR_`var'@0bn.exp] = _b[c.INR_`var'@1.exp]
}
}

*Works Council
foreach var in zf7 zf5 zf6 zf4  {
svy: reg INR_`var' exp##work_council
}

foreach var in zf7 zf5 zf6 zf4 {
	forval n =0/1{
		di `n'
		svy: mean INR_`var' , over(exp), if work_council ==`n'
		test _b[c.INR_`var'@0bn.exp] = _b[c.INR_`var'@1.exp]
}
}

////////////////////////////////////////////////////////////////////////////////
*7. Check Difference between Respondents and Nonrespondents with regard to item duration - CHECK
////////////////////////////////////////////////////////////////////////////////
svy:reg duration_zf6 INR_zf6
svy:reg duration_zf5 INR_zf5
svy:reg duration_zf7 INR_zf7

*Interaction with experiment
svy:reg duration_zf6 INR_zf6##exp
svy:reg duration_zf5 INR_zf5##exp
svy:reg duration_zf7 INR_zf7##exp

////////////////////////////////////////////////////////////////////////////////
*8. Sensivity-Check for break offs - CHECK
////////////////////////////////////////////////////////////////////////////////
foreach var in zf7 zf5 zf6 zf4 {
	svy: mean INR_`var' , over(exp) 
	test _b[c.INR_`var'@0bn.exp] = _b[c.INR_`var'@1.exp]

	svy: mean INR_`var' , over(exp), if duration_`var' !=.
	test _b[c.INR_`var'@0bn.exp] = _b[c.INR_`var'@1.exp]
}

////////////////////////////////////////////////////////////////////////////////
*9. More Spillover effects - CHECK
////////////////////////////////////////////////////////////////////////////////
foreach var in z12n zf16 zf16b zf16c zf8 zf171e_1 zf181 zf182_1 zf187 {
	svy: mean INR_`var' , over(exp) 
	test _b[c.INR_`var'@0bn.exp] = _b[c.INR_`var'@1.exp]
}

log close
exit




